/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.inventorymanagement.inventory;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import me.roundaround.inventorymanagement.inventory.sorting.ItemStackComparator;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1724;
import net.minecraft.class_1799;

public class InventoryHelper {
    public static void sortInventory(class_1657 player, boolean isPlayerInventory) {
        class_1661 inventory;
        class_1263 containerInventory = InventoryHelper.getContainerInventory(player);
        Object object = inventory = isPlayerInventory || containerInventory == null ? player.method_31548() : containerInventory;
        if (inventory instanceof class_1661) {
            InventoryHelper.sortInventory((class_1263)inventory, SlotRange.playerMainRange());
        } else {
            InventoryHelper.sortInventory((class_1263)inventory);
        }
    }

    private static void sortInventory(class_1263 inventory) {
        InventoryHelper.sortInventory(inventory, 0, inventory.method_5439());
    }

    private static void sortInventory(class_1263 inventory, int start, int end) {
        InventoryHelper.sortInventory(inventory, new SlotRange(start, end));
    }

    private static void sortInventory(class_1263 inventory, SlotRange slotRange) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (int i = slotRange.min; i < slotRange.max; ++i) {
            stacks.add(inventory.method_5438(i).method_7972());
        }
        List cleanedStacks = stacks.stream().filter(itemStack -> !itemStack.method_7960()).map(class_1799::method_7972).collect(Collectors.toList());
        for (int i = 0; i < cleanedStacks.size(); ++i) {
            for (int j = i + 1; j < cleanedStacks.size(); ++j) {
                int itemsToShift;
                class_1799 b;
                class_1799 a = (class_1799)cleanedStacks.get(i);
                if (!InventoryHelper.areItemStacksMergeable(a, b = (class_1799)cleanedStacks.get(j)) || (itemsToShift = Math.min(a.method_7914() - a.method_7947(), b.method_7947())) <= 0) continue;
                a.method_7933(itemsToShift);
                b.method_7934(itemsToShift);
            }
        }
        List sortedStacks = cleanedStacks.stream().filter(itemStack -> !itemStack.method_7960()).sorted(ItemStackComparator.comparator()).collect(Collectors.toList());
        for (int i = slotRange.min; i < slotRange.max; ++i) {
            int j = i - slotRange.min;
            class_1799 itemStack2 = j >= sortedStacks.size() ? class_1799.field_8037 : (class_1799)sortedStacks.get(j);
            inventory.method_5447(i, itemStack2);
        }
    }

    public static void autoStack(class_1657 player, boolean fromPlayerInventory) {
        class_1263 containerInventory = InventoryHelper.getContainerInventory(player);
        if (containerInventory == null) {
            return;
        }
        class_1661 playerInventory = player.method_31548();
        if (fromPlayerInventory) {
            InventoryHelper.autoStackInventories((class_1263)playerInventory, containerInventory, player);
        } else {
            InventoryHelper.autoStackInventories(containerInventory, (class_1263)playerInventory, player);
        }
    }

    public static void transferAll(class_1657 player, boolean fromPlayerInventory) {
        class_1263 containerInventory = InventoryHelper.getContainerInventory(player);
        if (containerInventory == null) {
            return;
        }
        class_1661 playerInventory = player.method_31548();
        SlotRange playerSlotRange = SlotRange.playerMainRange();
        SlotRange containerSlotRange = SlotRange.fullRange(containerInventory);
        if (player.field_7512 instanceof class_1724) {
            containerSlotRange = SlotRange.horseMainRange(containerInventory);
        }
        if (fromPlayerInventory) {
            InventoryHelper.transferEntireInventory((class_1263)playerInventory, containerInventory, playerSlotRange, containerSlotRange, (class_1703)player.field_7498, player.field_7512, player);
        } else {
            InventoryHelper.transferEntireInventory(containerInventory, (class_1263)playerInventory, containerSlotRange, playerSlotRange, player.field_7512, (class_1703)player.field_7498, player);
        }
    }

    private static void autoStackInventories(class_1263 from, class_1263 to, class_1657 player) {
        InventoryHelper.autoStackInventories(from, to, SlotRange.fullRange(from), SlotRange.fullRange(to), player);
    }

    private static void autoStackInventories(class_1263 from, class_1263 to, SlotRange fromRange, SlotRange toRange, class_1657 player) {
        InventoryHelper.transferEntireInventory(from, to, fromRange, toRange, (fromStack, toStack) -> !toStack.method_7960(), player);
    }

    private static void transferEntireInventory(class_1263 from, class_1263 to, SlotRange fromRange, SlotRange toRange, BiFunction<class_1799, class_1799, Boolean> predicate, class_1657 player) {
        InventoryHelper.transferEntireInventory(from, to, fromRange, toRange, predicate, null, null, player);
    }

    private static void transferEntireInventory(class_1263 from, class_1263 to, SlotRange fromRange, SlotRange toRange, class_1703 fromScreenHandler, class_1703 toScreenHandler, class_1657 player) {
        InventoryHelper.transferEntireInventory(from, to, fromRange, toRange, (fromStack, toStack) -> true, fromScreenHandler, toScreenHandler, player);
    }

    private static void transferEntireInventory(class_1263 from, class_1263 to, SlotRange fromRange, SlotRange toRange, BiFunction<class_1799, class_1799, Boolean> predicate, class_1703 fromScreenHandler, class_1703 toScreenHandler, class_1657 player) {
        for (int toIdx = toRange.min; toIdx < toRange.max; ++toIdx) {
            for (int fromIdx = fromRange.min; fromIdx < fromRange.max; ++fromIdx) {
                class_1799 fromStack = from.method_5438(fromIdx).method_7972();
                class_1799 toStack = to.method_5438(toIdx).method_7972();
                if (fromStack.method_7960() || !predicate.apply(fromStack, toStack).booleanValue() || !InventoryHelper.canTakeItemFromSlot(fromScreenHandler, fromIdx, player) || !InventoryHelper.canPlaceItemInSlot(toScreenHandler, toIdx, fromStack)) continue;
                if (InventoryHelper.areItemStacksMergeable(toStack, fromStack)) {
                    int space = toStack.method_7914() - toStack.method_7947();
                    int amount = Math.min(space, fromStack.method_7947());
                    if (amount <= 0) continue;
                    toStack.method_7933(amount);
                    fromStack.method_7934(amount);
                    to.method_5447(toIdx, toStack);
                    from.method_5447(fromIdx, fromStack.method_7960() ? class_1799.field_8037 : fromStack);
                    continue;
                }
                if (!toStack.method_7960() || fromStack.method_7960()) continue;
                to.method_5447(toIdx, fromStack);
                from.method_5447(fromIdx, class_1799.field_8037);
            }
        }
    }

    private static boolean canTakeItemFromSlot(class_1703 screenHandler, int idx, class_1657 player) {
        if (screenHandler == null) {
            return true;
        }
        try {
            return screenHandler.method_7611(idx).method_7674(player);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    private static boolean canPlaceItemInSlot(class_1703 screenHandler, int idx, class_1799 itemStack) {
        if (screenHandler == null) {
            return true;
        }
        try {
            return screenHandler.method_7611(idx).method_7680(itemStack);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public static class_1263 getContainerInventory(class_1657 player) {
        class_1703 currentScreenHandler = player.field_7512;
        if (currentScreenHandler == null) {
            return null;
        }
        try {
            return currentScreenHandler.method_7611((int)0).field_7871;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public static boolean areItemStacksMergeable(class_1799 a, class_1799 b) {
        return !a.method_7960() && !b.method_7960() && class_1799.method_31577((class_1799)a, (class_1799)b);
    }

    static class SlotRange {
        public int min;
        public int max;

        public SlotRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public static SlotRange fullRange(class_1263 inventory) {
            return new SlotRange(0, inventory.method_5439());
        }

        public static SlotRange playerMainRange() {
            return new SlotRange(class_1661.method_7368(), 36);
        }

        public static SlotRange horseMainRange(class_1263 inventory) {
            return new SlotRange(2, inventory.method_5439());
        }
    }
}

